//
//  MCRestRequestDefines.h
//  MCFoundation
//
//  Created by Thomas Bartelmess on 13.02.10.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef enum  {
	MCRestRequestStatusCodeContinue		      	= 100,
	MCRestRequestStatusCodeOK					= 200,
	MCRestRequestStatusCodeCreated				= 201,
	MCRestRequestStatusCodeAccepted		      	= 202,
	MCRestRequestStatusCodeNonAuthInfo			= 203,
	MCRestRequestStatusCodeNoContent			= 204,
	MCRestRequestStatusCodeResetContent	       	= 205,
	MCRestRequestStatusCodePartialContent		= 206,
	MCRestRequestStatusCodeMultiChoices		    = 300,
	MCRestRequestStatusCodeMovedPermanently	    = 301,
	MCRestRequestStatusCodeFound				= 302,
	MCRestRequestStatusCodeSeeOther			    = 303,
	MCRestRequestStatusCodeNotModified			= 304,
	MCRestRequestStatusCodeUseProxy			    = 305,
	MCRestRequestStatusCodeTempRedirect		    = 307,	
	MCRestRequestStatusCodeBadRequest			= 400,
	MCRestRequestStatusCodeUnauthorized		    = 401,
	MCRestRequestStatusCodePaymentRequired		= 402,
	MCRestRequestStatusCodeForbidden			= 403,
	MCRestRequestStatusCodeNotFound			    = 404,
	MCRestRequestStatusCodeMethodNotAllowed	    = 405,
	MCRestRequestStatusCodeNotAcceptable		= 406,
	MCRestRequestStatusCodeProxyAuthRequired	= 407,
	MCRestRequestStatusCodeRequestTimeout		= 408,
	MCRestRequestStatusCodeConflict			    = 409,
	MCRestRequestStatusCodeGone				    = 410,
	MCRestRequestStatusCodeLengthRequired		= 411,
	MCRestRequestStatusCodePreconditionFailed	= 412,
	MCRestRequestStatusCodeRequestEntTooLarge	= 413,
	MCRestRequestStatusCodeRequestURITooLong	= 414,
	MCRestRequestStatusCodeUnsupportedMedia	    = 415,
	MCRestRequestStatusCodeRangeNotSatisfiable	= 416,
	MCRestRequestStatusCodeExpectationFailed	= 417,
	MCRestRequestStatusCodeInternalServerError	= 500,
	MCRestRequestStatusCodeNotImplemented		= 501,
	MCRestRequestStatusCodeBadGateway			= 502,
	MCRestRequestStatusCodeServiceUnavailable	= 503,
	MCRestRequestStatusCodeGatewayTimeout		= 504,
	MCRestRequestStatusCodeVersionNotSupported	= 505
	
} MCRestRequestStatusCode;

extern NSString * kMCRestRequestParameterArrayPlistKey;
extern NSString * kMCRestRequestURLPlistKey;
extern NSString * kMCRestRequestURLNeedsParametersPlistKey;

extern NSString * kMCRestRequestParameterNameDictKey;
extern NSString * kMCRestRequestParameterTypeDictKey;
extern NSString * kMCRestRequestParameterIsRequiredDictKey;


extern NSString * kMCRestRequestRequiredKeyNotFoundExceptionName;
extern NSString * kMCRestRequestRequiredKeyNotFoundExceptionReason;

extern NSString * kMCRestRequestDatasourceCanNotProvivedNeededURLParametersExceptionName;
extern NSString * kMCRestRequestDatasourceCanNotProvivedNeededURLParametersExceptionReason;

extern NSString * kMCRestRequestNeedsAuthenticationKey;

extern NSString * kMCRestRequestRequestTypeShortcutKey;
extern NSString * kMCRestRequestContentTypeShortcutKey;
extern NSString * kMCRestRequestResponseCodesTemplateKey;

extern NSString * kMCRestRequstHttpRequestTypeTranslationsPlistFilename;
extern NSString * kMCRestRequstHttpRequestTypeTranslationsPlistFiletype;

extern NSString * kMCRestRequstContentTypeTranslationsPlistFilename;
extern NSString * kMCRestRequstContentTypeTranslationsPlistFiletype;

extern NSString * kMCRestRequestResultInfoDictResponseDataKey;
extern NSString * kMCRestRequestResultInfoDictStatusCodeKey;

extern NSString * kMCRestRequestRemoteErrorDomain;
extern NSString * kMCRestRequestUnknownRemoteErrorDomain;
extern NSString * kMCRestRequestAuthenticationError;

extern NSString * kMCRestRequestContentTypeHTTPHeaderField;
extern NSString * kMCRestRequestContentTypeStringJSON;
extern NSString * kMCRestRequestContentTypeStringXML;
extern NSString * kMCRestRequestContentTypeStringHTML;
extern NSString * kMCRestRequestContentTypeStringPlain;
extern NSString * kMCRestRequestContentTypeStringPlainXML;

extern NSString * kMCRestRequestContentTypeShortcutJSON;
extern NSString * kMCRestRequestContentTypeShortcutXML;
extern NSString * kMCRestRequestContentTypeShortcutHTML;
extern NSString * kMCRestRequestContentTypeShortcutPlain;
extern NSString * kMCRestRequestContentTypeShortcutPlainXML;

extern NSString * kMCRestRequestHTTPRequestTypePost;
extern NSString * kMCRestRequestHTTPRequestTypeGet; 
extern NSString * kMCRestRequestHTTPRequestTypePut;
extern NSString * kMCRestRequestHTTPRequestTypeDelete; 
extern NSString * kMCRestRequestHTTPRequestTypeTrace;
extern NSString * kMCRestRequestHTTPRequestTypeOptions; 
extern NSString * kMCRestRequestHTTPRequestTypeConnect; 

